c     -------------------------------------------------------------------HYDRO
      subroutine hydro (coord,itmp,khdr,neq,numel,numnp,windo,kpor,rdis,
     +ndatam,propma,nummat,b0dat,ipor,kseis,kfrc)
      implicit double precision (a-h,o-z)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
      common /waterf/ wli,wlf,dwl,uw,cwl,nwet,nhdr,iwl
      common /bacup/ nvec,iother(7),iwet,ifals(3)
      dimension coord(2,1),itmp(1),windo(1),idata(3),propma(ndatam,1),
     +b0dat(nummat)
c
c.....This routine reads the reservoir level data and the upstream face nodes
c.....that may experinece reservoir pressure loads
c
c                               Sudip S. Bhattacharjee/September 22,1993/Ecole
c
      kh=0
      call find ('HYDR',kh)
      if (kh .ne. 0) then
         write (ntm,1001)
         write (not,1001)
         khdr=0
         return
      endif
c.....W=depth of wat., U=unit wt. of wat., I=no. of nodes in contact with wat.
c.....D=differential increment of the  reservoir level, and K=no. of steps
      call free
      call freer ('W',wli,1)
      wlf=wli
      call freer ('U',uw,1)
      if (kseis .eq. 0) then
         call freer ('D',dwl,1)
         call freei ('K',nhdr,1)
      endif
      call freei ('I',nwet,1)
c
      call freei ('P',kpor,1)
      if (kpor .ne. 0) khdr=-1
      if (kpor .lt. 0) kpor=0
c
      if (khdr .eq. -1  .or.  ipor .ne. 0) then
         call freer ('B',b0dat,nummat)
         do 10 i=1,nummat
            propma(3,i)=b0dat(i)
            b0dat(i)=0.d0
   10    continue
         write (not,8001) (i,propma(3,i),i=1,nummat)
      endif
      if (nwet .eq. 0) then
         nhdr=0
c         if (khdr .eq. 1) khdr=0
         khdr=0
         write (not,1002)
         write (ntm,1002)
         return
      endif
      if (dwl .eq. 0.d0) nhdr=0
c      if (khdr .eq. -1  .and.  nhdr .eq. 0) return
      write (not,1003) wli,uw,dwl,nhdr,nwet
c.....Input the wet nodes
      if (nwet .gt. numnp) nwet=numnp
      k=0
  100 k=k+1
        call free
c        call izero(idata,3)
        idata(2)=0
        call freei('N',idata,3)
        i1=idata(1)
        i2=idata(2)
        itmp(k)=i1
        if (i2 .eq. 0) go to 300
           incre=idata(3)
  200      i1=i1+incre
           k=k+1
           itmp(k)=i1
           if (i1 .ne. i2  .and.  k .lt. nwet) go to 200
  300   continue
      if (k .lt. nwet) go to 100
c.....Order the wet nodes starting from the top towards the reservoir bottom
      call descend (nwet,itmp,coord(1,1))
      cwl=coord(2,itmp(1))
c.....Setting the inital water level at the crest level if and indirect
c     displacement analysis is requested, and the 
      if (rdis .ne. 0.d0  .and.  kfrc .eq. 0) then
         if (wlf .lt. cwl) then
             wlf=cwl
             write (not,2003) cwl
             write (ntm,2003) cwl
         endif
         wli=wlf
         if (wlf .eq. cwl  .and.  dwl .lt. 0.d0) dwl=0.d0
      endif
      write (not,1004) (itmp(k),k=1,nwet)
      cmax=cwl
      do 400 i=1,numnp
         if (coord(2,i) .gt. cmax) cmax=coord(2,i)
  400 continue
      if (cmax .gt. cwl) then
         write (not,6001) cwl,cmax
         write (ntm,6001) cwl,cmax
      endif
      call setnwl (itmp,coord)
      if (nhdr .ne. 0) then
         nvec=nvec+1
         iwet=nvec
         nnq=(neq+1)
         iwet=numel*4+(iwet-2)*nnq+1
         call copyi (windo(iwet),itmp,nwet)
         write (not,1005)
         write (ntm,1005)
      else
         write (not,1006)
         write (ntm,1006)
      endif
c
 1001 format (//10x,'The data block HYDR is not specified.',/10x,'No',
     +' water pressure (external or internal) is applied to the system')
 1002 format ('**No water pressure (external or internal) is applied to',
     +' the structure**')
 1003 format (/11x,' The inital water level in the reservoir  :',f10.5,
     +        /11x,' The unit weight of water                 :',f10.5,
     +        /11x,' Differential increment of the water level:',f10.5,
     +        /11x,' No. of incremental steps to be applied   :',i10,
     +        /11x,' Total no. of possible wet nodes is      :',i10)
 2003 format (/11x,'The inital water level is assumed at the dam crest',
     +'=',f16.5,/11x,'for the indirect control analysis')
 1004 format (/11x,' The possible wet nodes are   :'/(16i5))
 1005 format (/11x,'**The reservoir level will be increased in steps**')
 1006 format (/5x,'** The reservoir pressure will be applied in a',
     +' single step only **')
 6001 format (//' Elevation of the first node :',f10.5,
     +/         ' Highest point in the dam    :',f10.5,
     +/'************WARNING***********',
     +/' Check the specified upstream nodes for hydrostatic pressure',
     +/'                      computation ')
 8001 format (//'Initial Biot''s coefficients for porous material(s)',
     +//'Material ID no.',20x,'Biot''s coefficient (b_0)',
     +/(i10,25x,f12.5))
c
      return
      end
c     ------------------------------------------------------------------DESCEND
      subroutine descend (nwet,itmp,coord)
      implicit double precision (a-h,o-z)
      dimension itmp(1),coord(2,1)
c
c     Arranges the upstream side nodes starting from the reservoir top towards
c     the bottom
c                                        Sudip S.B./Sept.28,1993/Ecole
c
      do 200 i=1,nwet
         imax=i
         nmax=itmp(i)         
         cmax=coord(2,nmax)
         is=i+1
         do 100 j=is,nwet
            node=itmp(j)
            if (coord(2,node) .gt. cmax) then
               imax=j
               nmax=node
               cmax=coord(2,node)
            endif
  100    continue
         itmp(imax)=itmp(i)
         itmp(i)=nmax
  200 continue
c
      return
      end
c     ------------------------------------------------------------------SETNWL
      subroutine setnwl (itmp,coord)
      implicit double precision (a-h,o-z)
      dimension itmp(1),coord(2,1)
      common /waterf/ wli,wlf,dwl,uw,cwl,nwet,nhdr,iwl
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
c.....Set the first node adjacent to the water level
c      print *, (itmp(i),i=1,nwet)
      do 10 ist=1,nwet
         node=itmp(ist)
c         print*, ist,node
         if (coord(2,node) .lt. wlf) go to 20
   10 continue
      write (not,1001) nwet,wlf
      write (ntm,1001) nwet,wlf
      iwl=nwet
      return
   20 continue
      write (not,1002) wlf
      write (ntm,1002) wlf
      if (ist .gt. 1) ist=ist-1
      if (ist .gt. 1) write (not,1003) (itmp(i),i=1,ist-1)
      iwl=ist
      write (not,1004) (itmp(k),k=ist,nwet)
c
 1001 format (/' All',i4,' specified upstream nodes are above the',
     +' water level of:',f10.4/'** No hydrostatic pressure included **')
 1002 format (/' The current water level =',f10.4)
 1003 format (/' The following upstream nodes are still dry:',/(16i5))
 1004 format (/' The wet nodes are:'/(16i5))
c
      return
      end
c     -------------------------------------------------------------------HFORS
      subroutine hfors (f,numdof,coord,itmp,hforce)
      implicit double precision (a-h,o-z)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
      common /waterf/ wli,wlf,dwl,uw,cwl,nwet,nhdr,iwl
      dimension f(1),numdof(3,1),coord(2,1),itmp(1)
c
c.....This routine generates the hydro-static pressure loads and adds to the
c     global load vector
c
c                               Sudip S. Bhattacharjee/November 20,1991/McGill
c                               modified              /September22,1993/Ecole
c
c     This has been adapted from subroutine TOTAL (in sub5.for) of EAGD-84
c
      hforce=0.d0
      if (iwl .eq. nwet) then
         write (not,1001)
         return
      endif
c
      ist=iwl
      i=itmp(ist)
      j=itmp(ist+1)
      i1=numdof(1,i)
      i2=numdof(2,i)
      j1=numdof(1,j)
      j2=numdof(2,j)
c
      x=wlf-coord(2,j)
      pj=uw*x
      dy=coord(2,i)-coord(2,j)
      dx=coord(1,i)-coord(1,j)
      x1=wlf-coord(2,i)
      if (x1 .le. 0.d0) go to 400
         pj=uw*x1
         nf=ist
         go to 410
  400 frac=x/dy
      term=pj*frac/6.d0
      ri1= term*frac*dy
      ri2=-term*frac*dx
      term= term*(1.d0-frac/3.d0)*3.d0
      rj1= term*dy
      rj2=-term*dx
c
      hforce=hforce+ri1+rj1
      f(i1)=f(i1)+ri1
      f(i2)=f(i2)+ri2
      f(j1)=f(j1)+rj1
      f(j2)=f(j2)+rj2
      nf=ist+1
  410 continue
      nn=nwet-1
      do 450 k=nf,nn
         pi=pj
         i=itmp(k)
         j=itmp(k+1)
         i1=numdof(1,i)
         i2=numdof(2,i)
         j1=numdof(1,j)
         j2=numdof(2,j)
         dx=coord(1,i)-coord(1,j)
         dy=coord(2,i)-coord(2,j)
         pj=uw*(wlf-coord(2,j))
         term1=(2.d0*pi+pj)/6.d0
         term2=(2.d0*pj+pi)/6.d0
         ri1= term1*dy
         ri2=-term1*dx
         rj1= term2*dy
         rj2=-term2*dx
c
         hforce=hforce+ri1+rj1
         f(i1)=f(i1)+ri1
         f(i2)=f(i2)+ri2
         f(j1)=f(j1)+rj1
         f(j2)=f(j2)+rj2
  450 continue
c
 1001 format (/' ** All specified upstream nodes are above the water',
     +' level **'/' ** No hydrostatic pressure is included in the',
     +' current load step **')
c
      return
      end
c     -------------------------------------------------------------------PORE
      subroutine pore (ndof,iele,f,poren,khdr,kpor,ndatam,propma,porel,
     +ipor)
      implicit double precision (a-h,o-z)
      dimension ndof(1),iele(1),f(1),poren(1),propma(1),porel(1)
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
c     Adds the pore-water pressure to the static load vector.
c
c                                 Sudip S.B./Ecole Poly./Sept.08/1993
c                                 Modified              /Sept.15/1993
c

      fac=1.d0
      if (kpor .eq. 1) then
         write (not,1001)
         write (ntm,1001)
         call fopen (ntr,'por')
         read (ntr) fac
         read (ntr) (poren(i),i=1,numnp)
         call fclose (ntr)
      else
         write (not,1002)
         write (ntm,1002)
         call ppress (poren(1),khdr,fac)
      endif
      if (khdr .ne. -1) return
c
c.....If the specified pore pressure is higher the reservoir pressure at the
c     the point under consideration, reduce it ??
c.....
c.....Scale the pore-pressure data
      write (not,1003) fac
      write (ntm,1003) fac
      do 100 n=1,numnp
         poren(n)=poren(n)*fac
  100 continue
c.....Assemble to the total load vector
      call assempr (f,poren,ndof,iele,ndatam,propma,porel,ipor)
c
 1001 format (//' The pore pressure data for all nodal points are',
     +' expected in an'/' unformatted file named with an extension POR')
 1002 format (//' The non-zero pore pressure data for selected nodal',
     +/' points are specified in the PORE data block')
 1003 format (//' Scaling factor for the specified nodal pore pressure',
     +' values =',f12.5)
c
      return
      end
c     -------------------------------------------------------------------PORMAX
      subroutine pormax (coord,porel,iele,nel,wlf,uw,idat,ldat,propma,
     +ndatam)
      implicit double precision (a-h,o-z)
      dimension coord(2,1),porel(4),iele(5),bmat(36),shp(16),yg(6),
     +idat(1),propma(ndatam)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
c     This routine saves the maximum possible differential pore pressure
c     in Gauss points of cracked elements
c
c                                 Sudip S.B./Ecole Poly./Nov.19/1993
c
      read (nt8,rec=nel) bmat,shp
      call izero (yg,12)
         do 100 i=1,4
            node=iele(i)
            yn=coord(2,node)
            yg(1)=yg(1)+shp(i)*yn
            yg(2)=yg(2)+shp(i+4)*yn
            yg(3)=yg(3)+shp(i+8)*yn
            yg(4)=yg(4)+shp(i+12)*yn
  100    continue
      do 200 n=1,4
c........assumed full reservoir pressure may develope in the Gauss points
c........wlf may upstream or downstream reservoir level
         dz=wlf-yg(n)
         dp=uw*dz-porel(n)
c         if (dp .lt. 0.d0) dp=0.d0
         yg(n)=dp
  200 continue
c      mat=iele(5)
      b0=propma(3)
      yg(5)=b0
      yg(6)=1.0
      call copyr (idat(ldat+50),yg,6)
c
      return
      end
c     -----------------------------------------------------------------ORTHOPOR
      subroutine orthopor (porel,idat,icode,coord,iele,nck,ncrk,ncel,
     +propma,ndatam,ndt)
      implicit double precision (a-h,o-z)
      dimension porel(4,1),idat(1),icode(1),coord(1),iele(5,1),
     +propma(ndatam,1),nck(1)
      common /waterf/ wli,wlf,dwl,uw,cwl,nwet,nhdr,iwl
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
c     initializes the crack pressure analysis data in ORHTO elements
c
c                                 Sudip S.B./Ecole Poly./Nov.19/1993
c
      do 900 m=1,ncrk
c........assumed the pore pressure remains constant in the downstream cracks.
c........this can be modified if the downstream reservoir level is known.
         if (nck(m) .ge. 0) go to 900
         do 500 n=1,ncel
            ldat=(n-1)*ndt+1
            id=idat(ldat)
            kprofi=icode(id)
            if (kprofi .eq. m) then
               mat=iele(5,id)
               call pormax (coord,porel(1,id),iele(1,id),id,wli,uw,idat,
     +         ldat,propma(1,mat),ndatam)
            endif
  500    continue
  900 continue
c
      return
      end
c     -------------------------------------------------------------------INIPOR
      subroutine inipor (coord,iele,idat,icode,porel,nck,id,propma,
     +ndatam,ldat)
      implicit double precision (a-h,o-z)
      dimension coord(1),iele(5),idat(1),icode(1),porel(4),nck(1),
     +propma(1)
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /crack/ rtn,ftol,icrack,ks,nlar,ncrk,ncel,mxk,ipd,ipor,ndt
      common /waterf/ wli,wlf,dwl,uw,cwl,nwet,nhdr,iwl
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
c     prepares data for crack pressure in a newly selected cracked element
c
c                                 Sudip S.B./Ecole Poly./Nov.19/1993
c
c     does not store data if the crack is not pressurized
c
      kprofi=icode(id)
      ncode=nck(kprofi)
      if (ncode .lt. 0) then
c         ldat=(id-1)*ndt+1           ** wrong
         call pormax (coord,porel(1),iele(1),id,wli,uw,idat,ldat,propma,
     +   ndatam)
      endif
c
      return
      end
c     -------------------------------------------------------------------CRKPOR
      subroutine crkpor (porel,bdat,iele,icode,idat,ndof,f,nck,
     +ncel,ndt)
      implicit double precision (a-h,o-z)
      dimension porel(4,1),bdat(36,1),iele(5,1),icode(1),
     +idat(1),ndof(1),f(1),nck(1),p(3),bmat(36),ckpr(6)
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /waterf/ wli,wlf,dwl,uw,cwl,nwet,nhdr,iwl
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
c     updates the load vector due to the change in pore pressure of cracked
c      elements.
c                                 Sudip S.B./Ecole Poly./Sept.15/1993
c                                 Modified              /Sept.20/1993
c
      dps=(wlf-wli)*uw
      wli=wlf
      call izero (p,6)
         do 500 n=1,ncel
            ldat=(n-1)*ndt+1
            id=idat(ldat)
            kprofi=icode(id)
            if (nck(kprofi) .ge. 0) go to 500
c...........
            call coprr (idat(ldat+50),ckpr(1),6)
c...........
            etai=ckpr(6)
            call coprr (idat(ldat+6),em0,1)
            call coprr (idat(ldat+26),em1,1)
            etaj=em1/em0
            deta=etai-etaj
            if (deta .lt. 1.0e-5 .and. dabs(dps) .lt. 1.0e-5) go to 500
c
c               bi=1.0-etai*(1.0-ckpor(5))
c               bj=1.0-etaj*(1.0-ckpor(5))
               bi=ckpr(5)
               if (etai .ne. 0.d0) then
                  bj=(deta+etaj*bi)/etai
               else
                  bj=1.d0
               endif
c....
               ckpr(5)=bj
               ckpr(6)=etaj
               call copr (bdat(1,id),bmat,36)
c
            do 400 i=1,4
c                                 make sure I did not add dps before
               pi=porel(i,id)
               ckpr(i)=ckpr(i)+dps
               if (ckpr(i) .lt. 0.d0) then
                  if (etai .ne. 0.d0) then
                      pj=pi*etaj/etai
                   else
                      pj=0.d0
                   endif
               else
                  pj=pi+deta*ckpr(i)+(1.0-etai)*dps
               endif
c
               porel(i,id)=pj
c....
               dp21=bj*pj-bi*pi
               p(1)=dp21
               p(2)=dp21
               ii=(i-1)*9+1
               call restor (p,f,bmat(ii),bmat(ii+8),iele(1,id),ndof)
  400       continue
            call copyr (idat(ldat+50),ckpr(1),6)
  500    continue
c
      return
      end
c     -------------------------------------------------------------------SUMP
      subroutine sump (nck,icode,idat,ncrk,ncel,pord,ndt)
      implicit double precision (a-h,o-z)
      dimension nck(1),icode(1),idat(1),pord(4,1),iex(5),pex(2,5)
      common /waterf/ wli,wlf,dwl,uw,cwl,nwet,nhdr,iwl
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
c     Prints the summary of pore pressure in side cracks
c
c                                 Sudip S.B./Ecole Poly./Sept.15/1993
      do 900 m=1,ncrk
         if (nck(m) .ge. 0) go to 900
         write (not,4001) m
c         write (ntm,4001) m
         ict=0
         do 500 n=1,ncel
            ldat=(n-1)*ndt+1
            id=idat(ldat)
            kprofi=icode(id)
            if (kprofi .ne. m) go to 500
            call coprr (idat(ldat+58),biot,1)
            ict=ict+1
            iex(ict)=id
            pex(1,ict)=biot
      pex(2,ict)=(pord(1,id)+pord(2,id)+pord(3,id)+pord(4,id))/4.0/uw
            if (ict .eq. 5) then
               write (not,4002) (iex(j),(pex(k,j),k=1,2),j=1,ict)
c               write (ntm,4002) (iex(j),(pex(k,j),k=1,2),j=1,ict)
               ict=0
            endif
  500    continue
         if (ict .ne. 0) then
               write (not,4002) (iex(j),(pex(k,j),k=1,2),j=1,ict)
c               write (ntm,4002) (iex(j),(pex(k,j),k=1,2),j=1,ict)
          endif
  900 continue
c
 4001 format (//' Pore pressure inside the elements of upstream crack',
     +' profile no:',i4)
 4002 format (5(i4,':',f4.2,'(',f6.2,')'))
c
      return
      end
c     -------------------------------------------------------------------PPRESS
      subroutine ppress (poren,khdr,fac)
      implicit double precision (a-h,o-z)
      character*1 blnk,test
      dimension poren(1),itmp(3)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
      data blnk /' '/
c
c     This routine reads the specified non-zero pore-pressures at the nodes
c
c                               Sudip S.B./Ecole Poly./Sept.08/1993
c
      kp=0
      call find ('PORE',kp)
      if (kp .ne. 0) then
         write (not,1001)
         write (ntm,1001)
         if (khdr .eq. -1) khdr=1
         return
      else
         continue
      endif
      call free
      call freer ('F',fac,1)
c
      nn=0
  100 call free
      call freeh (' ',test,1,1)
      if (test .eq. blnk) go to 300
      call freei ('N',node,1)
      data=0.d0
      call freer ('U',data,1)
      poren(node)=data
c
      nn=nn+1
      itmp(1)=0
      call freei ('G',itmp,3)
      i1=itmp(1)
      if (i1 .eq. 0) go to 100
         i2=itmp(2)
         inc=itmp(3)
         do 120 n=i1,i2,inc
            poren(n)=data
            nn=nn+1
  120    continue
         go to 100
  300 continue
      write (not,1002) nn
c
 1001 format (//' Pore-pressure stress analysis requested, but the',
     +' data card PORE'/' is missing in the input data file')
 1002 format (//' Total',i3,' nodal pore-pressure cards specified')
c
      return
      end
c     ------------------------------------------------------------------ASSEMPR
      subroutine assempr (f,poren,ndof,iele,ndatam,propma,porel,ipor)
      implicit double precision (a-h,o-z)
      dimension f(1),poren(1),ndof(1),iele(5,1),bmat(36),shp(16),p(4),
     +propma(ndatam,1),p0(4),porel(4,1)
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
c     This routine asembles the pore-pressure data to the global load vector.
c
c                               Sudip S.B./Ecole Poly./Sept.08/1993
c                  modified                           /Nove.18/1993
c
      do 500 n=1,numel
         read (nt8,rec=n) bmat,shp
         do 10 i=1,4
            nn=iele(i,n)
            p(i)=poren(nn)
   10 continue
c.....inital stress formulation
      mat=iele(5,n)
      call comps (p,bmat,shp,iele(1,n),ndof,f,propma(3,mat),p0)
c.....store the inital pore pressure for transient pressure analyses
      if (ipor .ne. 0) call copr (p0,porel(1,n),4)
c........gradient formulation
c         call compg (p,bmat,shp,iele(1,n),ndof,f)
  500 continue
c
      return
      end
c     --------------------------------------------------------------------COMPS
      subroutine comps (p,bmat,shp,iele,ndof,f,biot,p0)
      implicit double precision (a-h,o-z)
      dimension p(4),bmat(36),shp(16),iele(4),ndof(1),f(1),pf(3),p0(4)
c
c     Assembles the pore-pressures as the inital stresses to the load vector
c
c                                         Sudip S.B./Ecole Poly./Nov.18, 1993
c
      do 100 igp=1,4
         kk=(igp-1)*4
         pp=0.d0
         do 20 k=1,4
            pp=pp+shp(kk+k)*p(k)
   20    continue
         p0(igp)=pp
         pf(1)=pp*biot
         pf(2)=pp*biot
         pf(3)=0.d0
c
         ii=(igp-1)*9+1
         call restor (pf,f,bmat(ii),bmat(ii+8),iele(1),ndof)
  100 continue
c
      return
      end
c     --------------------------------------------------------------------COMPG
      subroutine compg (p,bmat,shp,iele,ndof,f)
      implicit double precision (a-h,o-z)
      dimension p(4),bmat(36),shp(16),iele(4),ndof(3,1),f(1),pf(2,4)
c
c     Computes the nodal forces for specified pore-pressure gradient
c
c                                         Sudip S.B./Ecole Poly./Sept.15, 1993
c
      call izero (pf(1,1),16)
      do 100 igp=1,4
         k=(igp-1)*9+1
         ux=bmat(k)*p(1)+bmat(k+2)*p(2)+bmat(k+4)*p(3)+bmat(k+6)*p(4)
         k=k+1
         uy=bmat(k)*p(1)+bmat(k+2)*p(2)+bmat(k+4)*p(3)+bmat(k+6)*p(4)
         xjac=bmat(k+7)
         ux=-ux*xjac
         uy=-uy*xjac
         kk=(igp-1)*4
         do 20 i=1,4
            pf(1,i)=pf(1,i)+shp(kk+i)*ux
            pf(2,i)=pf(2,i)+shp(kk+i)*uy
   20    continue
  100 continue
c
      do 300 i=1,4
         node=iele(i)
         idof=ndof(1,node)
         jdof=ndof(2,node)
         f(idof)=f(idof)+pf(1,i)
         f(jdof)=f(jdof)+pf(2,i)
  300 continue
c
      return
      end
